﻿using C1.WPF.DataCollection;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace WPFFlexGridVirtualMode
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private VirtualModeCollectionView _virtualCollection;
        
        public MainWindow()
        {
            InitializeComponent();
            UpdateData();
        }

        private void UpdateData()
        {
            try
            {
                _virtualCollection = new VirtualModeCollectionView() { Mode = C1.DataCollection.VirtualDataCollectionMode.Manual };
                c1FlexGrid1.ItemsSource = new C1CollectionView(_virtualCollection); 
                c1FlexGrid1.ScrollPositionChanged += C1FlexGrid1_ScrollPositionChanged;
                _virtualCollection.LoadAsync(c1FlexGrid1.ViewRange.Row, c1FlexGrid1.ViewRange.Row2);

            }
            catch(Exception e)
            {
                MessageBox.Show(e.Message);
            }
        }

        private void C1FlexGrid1_ScrollPositionChanged(object sender, EventArgs e)
        {
            _virtualCollection.LoadAsync(c1FlexGrid1.ViewRange.Row, c1FlexGrid1.ViewRange.Row2);
        }
    }
}
