﻿using C1.DataCollection;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace WPFFlexGridVirtualMode
{
    public class VirtualModeCollectionView : C1VirtualDataCollection<Customer>
    {
        public VirtualModeCollectionView()
        {
            PageSize = 50;
        }
        public int TotalCount { get; set; } = 250_000;

        protected override async Task<Tuple<int, IReadOnlyList<Customer>>> GetPageAsync(int pageIndex, int startingIndex, int count, IReadOnlyList<SortDescription> sortDescriptions = null, FilterExpression filterExpression = null, CancellationToken cancellationToken = default)
        {
            //await Task.Delay(500, cancellationToken);//Simulates network traffic.
            return new Tuple<int, IReadOnlyList<Customer>>(TotalCount, Enumerable.Range(startingIndex, count).Select(i => new Customer(i)).ToList());

        }

        public override Customer this[int index]
        {
            get
            {
                var item = base[index];
                if (item != null)
                    return item;
                return new Customer() { FirstName = "Loading...", LastName = "Loading...", Address = "Loading...", City = "Loading...", Email = "Loading..." };
            }

        }
    }
}
